getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(tensorA)
library(proxy)
library(abind)

load("s2-ini-setting-p-1.RData")

## Model: f(x) = B*U1*U2*x; B: 3*3*2, U1/2: 3*3, x:3*2
dim.b = c(3,2); dim.u = c(3,3); dim.x = c(2,2); 
dim.f = c(3,2); t1 = dim.f[1]; t2 = dim.f[2]
dim.h = prod(dim.f); dim.mode = length(dim.f)
dim.s = dim.f; s1 = dim.s[1]; s2 = dim.s[2]
d = 2; lower.x = rep(0,d); upper.x = rep(1,d)
k = ceiling(dim.h/6)

B <- e2.ini.set.p$B
U_mat <- e2.ini.set.p$U_mat
V <- e2.ini.set.p$V

true.model <- function(x){
  X1 = sin(5*x); X2 = cos(x)
  X = matrix(c(X1,X2),dim.x,byrow=T)
  return(array(ttm(V, X, m = 2)@data,dim.f))
}


true.h <- function(x,ind) {
  sele.f <- true.model(x)[ind]
  return(sum(sele.f))
}

ora.h <- function(x,k) {
  sele.f <- sort(true.model(x), decreasing = TRUE)[1:k]
  return(sum(sele.f))
}

ora.to.re = directL(function(x0) -ora.h(x0,k),lower.x,upper.x,control=list(xtol_rel=1e-8, maxeval=1000))
ora.x.star = ora.to.re$par
ora.x.star = t(as.matrix(ora.x.star))

ora.ind.star = arrayInd(order(true.model(ora.x.star), decreasing = TRUE)[1:k],dim.f)
ora.f.star = true.model(ora.x.star)
ora.h.star = ora.h(ora.x.star,k)


## Kernel
norm0 <- function(x1,x2) as.matrix(dist(x1,x2,method = "Euclidean"))
norm1 <- function(x1,x2){
  nor = list()
  for(i in 1:d){
    nor[[i]] = norm0(x1[,i],x2[,i])}
  return(nor)
} 

mat0 <- function(x) matern(x, phi=1, kappa=5/2)
gau0 <- function(x) exp(-x^2)
exp0 <- function(x) exp(-abs(x))

ker.sele <- function(x1,x2,theta,ker){
  x = norm1(x1,x2)
  dis = Map(function(x0,th) x0/th,x,theta)
  R0 = Map(function(x0) ker(x0),dis)
  R = Reduce("*", R0)
  return(R)
}

pos <- function(ind) array(1:dim.h,dim.f)[ind]

e.ind <- function(ind){
  e0 = pos(ind); ord = cbind(1:k,e0)
  e.re = matrix(0,k,dim.h)
  e.re[ord] = 1
  return(e.re)
}


################################################################################
#### GP ########################################################################
################################################################################

################################################################################
## Our proposed method: NS-TOGP
vec.lab = list()
for(om.lab in 1:dim.mode){
  vec.lab[[om.lab]] = dim.s[om.lab]*(dim.s[om.lab]+1)/2
}
vec.lab[[dim.mode+1]] = d
vec.lab[[dim.mode+2]] = vec.lab[[dim.mode+3]] = 1
group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.smt = length(group.lab)

lower.th = c(unlist(Map(rep, c(rep(1e-1,dim.mode),1e-1,1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(rep(1,dim.mode),10,10,1e-2), unlist(vec.lab))))

B.tuck.smt <- function(y,ind,n,s1,s2){
  y_0 = array(0,dim=c(dim.f,n))
  
  for (i in 1:n) {
    for(j in 1:k){
      idx <- ind[[i]]
      y_0[idx[j,1], idx[j,2], i] <- y[j,i]
    }
  }
  
  y0 = lapply(1:n, function(i) rTensor::as.tensor(y_0[,,i]))
  
  mode.unfold <- function(da,k) {
    do.call(cbind, lapply(da, function(x) { k_unfold(x,k)@data}))
  }
  
  U.1 <- svd(mode.unfold(y0, 1))$u[, 1:s1]
  U.2 <- svd(mode.unfold(y0, 2))$u[, 1:s2]
  
  core.ten <- lapply(y0, function(x) {
    ttl(x, list(t(U.1), t(U.2)), 1:dim.mode)
  })
  return(list(core.ten=core.ten, U.tuck=list(U.1=U.1,U.2=U.2)))
}

sig.smt <- function(t,ome){
  O = matrix(0,t,t)
  O[lower.tri(O, diag = TRUE)] <- ome
  return(O)
}

ker.smt <- function(y,ind,n,s1,s2,the){
  the0 = split(the, group.lab)
  
  b.ren = B.tuck.smt(y,ind,n,s1,s2)
  Omega = list(list(s1,the0[[1]]),list(s2,the0[[2]]))
  sig = lapply(Omega,function(the) sig.smt(the[[1]],the[[2]]))
  
  sig.tuck = Map(function(A,B) A%*%(B%*%t(B))%*%t(A), b.ren$U.tuck, sig)
  return(Reduce(kronecker,sig.tuck))
}


likeli.smt <- function(x1,x2,y,ind,n,s1,s2,the){
  the0 = split(the, group.lab)
  
  omega = ker.smt(y,ind,n,s1,s2,the)
  k.ini = ker.sele(x1,x2,the0[[dim.mode+1]],mat0)
  k.y = the0[[dim.mode+2]]*kronecker(k.ini,omega)+the0[[dim.mode+3]]*diag(n*dim.h)
  
  e.ini = as.matrix(bdiag(lapply(ind,e.ind)))
  par.k.y = e.ini%*%k.y%*%t(e.ini)+1e-8*diag(n*k)
  sol.par.k.y = ginv(e.ini%*%k.y%*%t(e.ini))
  
  log.likeli = determinant(par.k.y,logarithm=TRUE)$modulus+t(c(y))%*%sol.par.k.y%*%c(y)
  return(list(like=log.likeli, the0=the0))
}

smtgp.hat <- function(x.new,ind.new,x,y,ind,n,n.test,s1,s2,hy){
  x.new = matrix(x.new,n.test,d)
  e.new = as.matrix(bdiag(lapply(ind.new,e.ind)))
  e.ini = as.matrix(bdiag(lapply(ind,e.ind)))
  
  omega = ker.smt(y,ind,n,s1,s2,unlist(hy))
  
  k.smt.s0 = ker.sele(x,x,hy[[dim.mode+1]],mat0)
  k.smt.s = hy[[dim.mode+2]]*kronecker(k.smt.s0,omega)+hy[[dim.mode+3]]*diag(n*dim.h)
  
  k.smt.10 = ker.sele(x.new,x,hy[[dim.mode+1]],mat0)
  k.smt.1 = hy[[dim.mode+2]]*kronecker(k.smt.10,omega)%*%t(e.ini)
  
  k.smt.00 = ker.sele(x.new,x.new,hy[[dim.mode+1]],mat0)
  k.smt.0 = hy[[dim.mode+2]]*kronecker(k.smt.00,omega)
  
  k.oth = k.smt.1%*%ginv(e.ini%*%k.smt.s%*%t(e.ini)+1e-8*diag(n*k))
  
  f.hat = k.oth%*%c(y)
  var.hat = k.smt.0-k.oth%*%t(k.smt.1)
  
  par.k.smt.1 = e.new%*%k.smt.1
  par.k.smt.0 = e.new%*%k.smt.0%*%t(e.new)
  par.k.oth = e.new%*%k.oth
  
  par.f.hat = par.k.oth%*%c(y)
  par.var.hat = par.k.smt.0-par.k.oth%*%t(par.k.smt.1)
  
  result = list(mean = f.hat, cov = var.hat, par.mean = par.f.hat, par.cov = par.var.hat)
  return(result)
}

EIJ <- function(i,j,l){
  E0 = matrix(0,dim.s[l],dim.s[l]); E0[i,j] = 1
  return(E0)
}

der.l <- function(x1,x2,y,ind,n,s1,s2,the){
  the0 = split(the, group.lab)
  
  ome = list()
  for(i in 1:dim.mode){ome[[i]] = the0[[i]]}
  th = the0[[dim.mode+1]]; sig2 = the0[[dim.mode+2]]; tau2 = the0[[dim.mode+3]]
  
  J <- function(i,l){
    E0 = matrix(0,dim.s[l],dim.s[l]); E0[i,i] = exp(sig.smt(dim.s[l],ome[[l]])[i,i])
    return(E0)
  }
  
  b.ren = B.tuck.smt(y,ind,n,s1,s2)$U.tuck
  Omega = list(list(s1,ome[[1]]),list(s2,ome[[2]]))
  sig = lapply(Omega,function(the) sig.smt(the[[1]],the[[2]]))
  sig.tuck = Map(function(A,B) A%*%(B%*%t(B))%*%t(A), b.ren, sig)
  omega = Reduce(kronecker,sig.tuck)
  
  k.ini = ker.sele(x1,x2,th,mat0)
  k.y = sig2*kronecker(k.ini,omega)+tau2*diag(n*dim.h)
  
  e.ini = as.matrix(bdiag(lapply(ind,e.ind)))
  par.k.y = e.ini%*%k.y%*%t(e.ini)+1e-8*diag(n*k)
  sol.par.k.y = ginv(e.ini%*%k.y%*%t(e.ini))
  
  al.k = sol.par.k.y%*%c(y)
  al.k1 = e.ini%*%kronecker(k.ini,omega)%*%t(e.ini)
  
  der.l.sig2 = tr(sol.par.k.y%*%al.k1)-t(al.k)%*%al.k1%*%al.k
  der.l.tau2 = tr(sol.par.k.y)-t(al.k)%*%al.k
  
  der.th = array(jacobian(function(theta) ker.sele(x1,x2,theta,mat0), th),dim=c(n,n,d))
  der.l.th.i <- function(der) sig2*(tr(sol.par.k.y%*%e.ini%*%kronecker(der,omega)%*%t(e.ini))-
                                      t(al.k)%*%e.ini%*%kronecker(der,omega)%*%t(e.ini)%*%al.k)
  der.l.th = apply(der.th,3,der.l.th.i)
  
  der.l.phi = list()
  for(l in 1:dim.mode){
    der.l.phi[[l]] = matrix(0, dim.s[l], dim.s[l])
    
    der.l.phi.ij <- function(i,j) b.ren[[l]]%*%(EIJ(i,j,l)%*%t(sig[[l]])+sig[[l]]%*%EIJ(j,i,l))%*%t(b.ren[[l]])
    it1 <- function(der.p){
      list1 = if (l > 1) sig.tuck[1:(l-1)] else 1
      list2 = if (l < dim.mode) sig.tuck[(l+1):dim.mode] else 1
      kro.list = list(sig2*k.ini,Reduce(kronecker,list1),der.p,Reduce(kronecker,list2))
      return(e.ini%*%Reduce(kronecker,kro.list)%*%t(e.ini))
    } 
    it2 <- function(der.p) tr(sol.par.k.y%*%it1(der.p))-t(al.k)%*%it1(der.p)%*%al.k
    
    der.l.phi.1 = sapply(c(1:dim.s[l]), function(i) {
      sapply(c(1:i), function(j) it2(der.l.phi.ij(i, j)))
    })
    
    der.l.phi.ii <- function(i) b.ren[[l]]%*%(J(i,l)%*%t(sig[[l]])+sig[[l]]%*%J(i,l))%*%t(b.ren[[l]])
    der.l.phi.dig = apply(as.matrix(c(1:dim.s[l])),1, function(i) it2(der.l.phi.ii(i)))
    
    for (i in 1:dim.s[l]) {
      der.l.phi[[l]][i, 1:i] <- der.l.phi.1[[i]]
    }
    # diag(der.l.phi[[l]]) = der.l.phi.dig   
  }
  
  result = list(der.l.phi=lapply(der.l.phi, function(mat) mat[lower.tri(mat, diag = TRUE)]), 
                der.l.th=der.l.th, der.l.sig2=der.l.sig2, der.l.tau2=der.l.tau2)
  return(result)
}


################################################################################
## Our proposed method: NS-SMTGP-UCB
n = 5*d; m  = 10*d; lambda = 0.1; J.for=10

like.re.smt = hyper.smt = lapply(1:J.for, function(x) list())
x0.smt = y0.smt = ind0.smt = list(); fhat = lapply(1:J.for, function(x) list())
smtgp.bo = h.smt = list()
mse.x.smt = mae.y.smt = list(); tab.ind.smt = list()
regret.smt = ins.regret.smt = cum.regret.smt = list()

for(j.for.smt in 1:J.for){
  x = e2.ini.set.p$x 
  k.ind = e2.ini.set.p$k.ind
  y = e2.ini.set.p$y.for[[j.for.smt]]
  
  ## Setting
  ######################################## BO ####################################
  hyper.smt.old = directL(function(the) likeli.smt(x,x,y,k.ind,n,s1,s2,the)$like,lower.th,upper.th,control=list(maxeval=1000))$par
  opts <- list("algorithm"="NLOPT_LD_LBFGS", "xtol_rel"=1.0e-5)
  hyper.smt.new = nloptr(x0=hyper.smt.old,
                         eval_f = function(the) likeli.smt(x,x,y,k.ind,n,s1,s2,the)$like,
                         eval_grad_f=function(the) unlist(der.l(x,x,y,k.ind,n,s1,s2,the)),
                         opts=opts,lb = lower.th, ub = upper.th)$solution
  
  like.re.smt[[j.for.smt]][[1]] = likeli.smt(x,x,y,k.ind,n,s1,s2,hyper.smt.new)
  hyper.smt[[j.for.smt]][[1]] = like.re.smt[[j.for.smt]][[1]]$the0
  
  x0.smt[[j.for.smt]] = x; y0.smt[[j.for.smt]] = y; ind0.smt[[j.for.smt]] = k.ind
  n.smt = n
  
  y.new.smt = y[,which.max(apply(y,2,sum))]
  x.new.smt = t(as.matrix(x[which.max(apply(y,2,sum)),]))
  ind.new.smt = list(k.ind[[which.max(apply(y,2,sum))]])
  
  hyper.smt.ucb = unlist(hyper.smt[[j.for.smt]][[1]]); delta.smt = 0.05
  fhat[[j.for.smt]][[1]] = smtgp.hat(x.new.smt,ind.new.smt,x,y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,1,s1,s2,hyper.smt[[j.for.smt]][[1]])
  
  for(i.smt in 1:m){
    x.new.smt = t(t(randomLHS(1,d))*(upper.x-lower.x) + lower.x)
    ind.new.smt = list(arrayInd(sample(dim.h,k),dim.f))
    
    fhat[[j.for.smt]][[i.smt+1]] = smtgp.hat(x.new.smt,ind.new.smt,x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,n.test=1,s1,s2,hyper.smt[[j.for.smt]][[i.smt]])
    y.new.smt = true.model(x.new.smt)[ind.new.smt[[1]]]+rnorm(k,mean=0,sd=lambda)
    
    x0.smt[[j.for.smt]] = rbind(x0.smt[[j.for.smt]], x.new.smt)
    y0.smt[[j.for.smt]] = cbind(y0.smt[[j.for.smt]], y.new.smt)
    ind0.smt[[j.for.smt]] = append(ind0.smt[[j.for.smt]], ind.new.smt)
    
    n.smt = n+i.smt
    
    if(i.smt %% 5 == 0){
      hyper.smt.ucb = nloptr(x0=unlist(hyper.smt[[j.for.smt]][[i.smt]]),
                             eval_f = function(the) likeli.smt(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,s1,s2,the)$like,
                             eval_grad_f=function(the) unlist(der.l(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,s1,s2,the)),
                             opts=opts,lb = lower.th, ub = upper.th)$solution
    }else{
      hyper.smt.ucb = hyper.smt.ucb
    }
    
    like.re.smt[[j.for.smt]][[i.smt+1]] = likeli.smt(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,s1,s2,hyper.smt.ucb)
    hyper.smt[[j.for.smt]][[i.smt+1]] = like.re.smt[[j.for.smt]][[i.smt+1]]$the0
    print(i.smt)
  }
  
  smtgp.bo[[j.for.smt]] = Map(function(a,b) true.model(a)[b],split(x0.smt[[j.for.smt]],row(x0.smt[[j.for.smt]])),ind0.smt[[j.for.smt]])
  h.smt[[j.for.smt]] = Map(function(a,b) true.h(a,b),split(x0.smt[[j.for.smt]],row(x0.smt[[j.for.smt]])),ind0.smt[[j.for.smt]])
  
  mse.x.smt[[j.for.smt]] = apply(x0.smt[[j.for.smt]],1,function(x) mean((x-ora.x.star)^2))
  mae.y.smt[[j.for.smt]] = unlist(lapply(fhat[[j.for.smt]],function(a) mean(abs((a$par.mean-ora.f.star[ora.ind.star])/ora.f.star[ora.ind.star]))))
  tab.ind.smt[[j.for.smt]] = unlist(lapply(ind0.smt[[j.for.smt]],function(a) sum(apply(a, 1, function(row) any(duplicated(rbind(row, ora.ind.star)))))))#unlist(lapply(ind0.smt[[j.for.smt]],function(a) sum(apply(a == ora.ind.star, 1, all))))
  
  regret.smt[[j.for.smt]] = ora.h.star-unlist(h.smt[[j.for.smt]])
  ins.regret.smt[[j.for.smt]] = ora.h.star-cummax(unlist(h.smt[[j.for.smt]]))
  cum.regret.smt[[j.for.smt]] = cumsum(ins.regret.smt[[j.for.smt]])
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(ora.h.star,(n.smt-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(h.smt[[j.for.smt]][n]),ora.h.star))
  lines(cummax(h.smt[[j.for.smt]])[n:n.smt],type="b",lwd=3,lty=2,pch=2,col=2)
  
  plot(log(ins.regret.smt[[j.for.smt]]+1e-10)[n:n.smt],type="b",lwd=3,lty=1,pch=1,col=1)
  
  print(j.for.smt)
}


psmt.rs.list = list(like.re.smt=like.re.smt, hyper.smt=hyper.smt, 
                     ind0.smt=ind0.smt, tab.ind.smt=tab.ind.smt,
                     x0.smt=x0.smt, y0.smt=y0.smt, smtgp.bo=smtgp.bo, h.smt=h.smt, 
                     mse.x.smt=mse.x.smt, mae.y.smt=mae.y.smt, 
                     regret.smt=regret.smt, ins.regret.smt=ins.regret.smt, cum.regret.smt=cum.regret.smt)
save(psmt.rs.list, file="s2.psmt.rs.RData")



























